//
//  pqCrashReporter.h
//  plasq Crash Reporter
//
//  Created by Bryce Magee on 22/06/06.
//  Copyright 2006 plasq. All rights reserved.
//
//
//  To use this framework:
//
//  - Import the header file e.g. 
//		#import <plasqCrashReporter/pqCrashReporter.h>
//
//  - Make a call to the class method "defaultCrashReporter" somewhere after startup, such as in awakeFromNib e.g.
//		[pqCrashReporter defaultCrashReporter];
//
//  - The "pqCrashReporterDontCheckAtStartup" preference uses bindings to link it to a checkbox on the crash report window.
//    Applications utilising this framework could do something similar in their preference panel if they wished to allow
//    the user to reset this flag. This way, either place could be used to update the preference without glue code.
//
//  The class is dealloced when the logging window is closed, so there's no real need to retain it.
//
//  Optional #defines: -D DEBUG -D ALWAYS_SHOW_CRASH_REPORT
//

#import <Cocoa/Cocoa.h>

extern NSString *pqCrashReporterDontCheckAtStartupKey;
extern NSString *pqCrashReporterLastContactNameKey;
extern NSString *pqCrashReporterLastEmailAddressKey;
extern NSString *pqCrashReporterDontUseEncryptionKey;
extern NSString *ApplicationLastCrashedDateTimeKey;

@interface pqCrashReporter : NSObject {
	IBOutlet id m_crashWindow;
	IBOutlet id m_crashLogTextView;
	IBOutlet id m_crashDescriptionTextView;
	IBOutlet id m_contactNameTextField;
	IBOutlet id m_contactEmailAddressTextField;
	//IBOutlet id m_startupCrashCheckbox;
	IBOutlet id m_progressSheet;
	IBOutlet id m_progressIndicator;
	NSMutableData *m_receivedData;
	NSURLConnection *connectionResponse;
}

+ (BOOL)dontCheckAtStartup;
+ (void)setDontCheckAtStartup:(BOOL)newValue;
+ (BOOL)dontUseEncryption;
+ (id)defaultCrashReporter; // This is the preferred method of using this class.
+ (id)defaultCrashReporterWithLog:(NSString *)path;
+ (NSString *)defaultCrashLogPath;
+ (NSString *)lastCrashReport; // this doesn't update the last crash date in prefs, thus acting like it's a "read only" gathering of data
+ (NSString *)lastCrashReportforPath:(NSString *)path resetCrashReport:(BOOL)resetCrashReport;
+ (BOOL)appendString:(NSString *)string toPath:(NSString *)path;
+ (NSString *)consoleLog;

- (IBAction)send:(id)sender;
- (IBAction)cancel:(id)sender;
//- (IBAction)startupCrashCheckChanged:(id)sender;
- (IBAction)progressSheetCancel:(id)sender;

- (void)sendRequest;

@end
